#include <malloc.h>
#include <setjmp.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "jpeglib.h"
#include "jerror.h"


extern void MsgOut( char* Msg );
extern void* Allocate( int size );
extern void* Reallocate( void* ptr, int size );


struct my_error_mgr {
  struct jpeg_error_mgr pub;    /* "public" fields */
  jmp_buf setjmp_buffer;        /* for return to caller */
};

typedef struct my_error_mgr * my_error_ptr;

/*
 * Here's the routine that will replace the standard error_exit method:
 */

METHODDEF(void)
my_error_exit (j_common_ptr cinfo)
{
  my_error_ptr myerr = (my_error_ptr) cinfo->err;

  (*cinfo->err->output_message) (cinfo);
  longjmp( myerr->setjmp_buffer, 1 );
}

METHODDEF(void)
my_output_message (j_common_ptr cinfo)
{
}


/* Data destination manager for memory output */

typedef struct {
  struct jpeg_destination_mgr pub; /* public fields */

  char** buffer;                   /* target stream */
  int    size;
  int    position;
  int*   Rc;
} my_destination_mgr;

typedef my_destination_mgr * my_dest_ptr;

METHODDEF(void)
init_destination (j_compress_ptr cinfo)
{
  my_dest_ptr dest = (my_dest_ptr) cinfo->dest;

  dest->size = 8192;
  *dest->buffer = (char*) Allocate( 8192 );
  dest->position = 0;
  *dest->Rc = 0;
  dest->pub.next_output_byte = *(dest->buffer);
  dest->pub.free_in_buffer = 8192;
}

METHODDEF(boolean)
empty_output_buffer (j_compress_ptr cinfo)
{
  my_dest_ptr dest = (my_dest_ptr) cinfo->dest;

  dest->size += 8192;
  *dest->buffer = Reallocate( *dest->buffer, dest->size );
  if( *dest->buffer == NULL ) ERREXIT(cinfo, JERR_FILE_WRITE);
  dest->position += 8192;
  *dest->Rc += 8192;
  dest->pub.next_output_byte = *dest->buffer + dest->position;
  dest->pub.free_in_buffer = 8192;
  return TRUE;
}

METHODDEF(void)
term_destination (j_compress_ptr cinfo)
{
  my_dest_ptr dest = (my_dest_ptr) cinfo->dest;
  size_t datacount = 8192 - dest->pub.free_in_buffer;

  if (datacount > 0) *dest->Rc += datacount;
}

GLOBAL(void)
jpeg_memory_dest (j_compress_ptr cinfo, char** Buffer, int* Rc )
{
  my_dest_ptr dest;

  if (cinfo->dest == NULL) {    /* first time for this JPEG object? */
    cinfo->dest = (struct jpeg_destination_mgr *)
      (*cinfo->mem->alloc_small) ((j_common_ptr) cinfo, JPOOL_PERMANENT,
                                  sizeof(my_destination_mgr));
  }
  dest = (my_dest_ptr) cinfo->dest;
  dest->pub.init_destination = init_destination;
  dest->pub.empty_output_buffer = empty_output_buffer;
  dest->pub.term_destination = term_destination;
  dest->buffer = Buffer;
  dest->Rc = Rc;
}

#define GET_DWORD( buf, offs ) ( *((unsigned*)((buf) + (offs))) )

extern int __export __syscall Main( char* Src, char** Dst, char* Params );

int __export __syscall Main( char* Src, char** Dst, char* Params )
  {
    struct jpeg_compress_struct cinfo;
    struct my_error_mgr jerr;
    unsigned  i, j, RowStride;
    unsigned  char *RowPtr, *Row = NULL;
    int       Rc;

    Rc = 0;
    cinfo.err = jpeg_std_error( &jerr.pub );
    jerr.pub.error_exit = my_error_exit;
    jerr.pub.output_message = my_output_message;
    if( setjmp( jerr.setjmp_buffer ) ) {
      jpeg_destroy_compress( &cinfo );
      Rc = 0;
    }
    else if( (Row = (unsigned char*) malloc( 3 *
                       GET_DWORD( (unsigned char*) Src, 0x12 ) )) != NULL ) {
      jpeg_create_compress( &cinfo );
      jpeg_memory_dest( &cinfo, Dst, &Rc );
      cinfo.image_width = GET_DWORD( (unsigned char*) Src, 0x12 );
      RowStride = (cinfo.image_width * 3 + 3) & ~3;
      cinfo.image_height = GET_DWORD( (unsigned char*) Src, 0x16 );
      cinfo.input_components = 3;
      cinfo.in_color_space = JCS_RGB;
      jpeg_set_defaults( &cinfo );
      cinfo.optimize_coding = TRUE;
      if( Params == NULL ) i = 75; else i = strtoul( Params, NULL, 0 );
      if( i <= 0 ) i = 75; else if( i > 100 ) i = 100;
      jpeg_set_quality( &cinfo, i, TRUE );
      jpeg_start_compress( &cinfo, TRUE );
      RowPtr = ((unsigned char*) Src) + 0x36 + RowStride * cinfo.image_height;
      while( cinfo.next_scanline < cinfo.image_height ) {
        RowPtr -= RowStride;
        for( i = j = 0; i < cinfo.image_width; i++, j += 3 ) {
          Row[ j ] = RowPtr[ j + 2 ];
          Row[ j + 1 ] = RowPtr[ j + 1 ];
          Row[ j + 2 ] = RowPtr[ j ];
        }
        jpeg_write_scanlines( &cinfo, &Row, 1 );
      }
      jpeg_finish_compress( &cinfo );
    }
    jpeg_destroy_compress( &cinfo );
    if( Row != NULL ) free( Row );
    _heapmin();
    return Rc;
  }
